/*
 
 File: AppDelegate.m
 Abstract: The application delegate for the developer sample.
 
 Version: 1.0
 
 Disclaimer: IMPORTANT:  This sample software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Genesys Inc. All Rights Reserved.
 
 */

#import "AppDelegate.h"

#import "ViewController.h"

@implementation AppDelegate

@synthesize window = _window;
@synthesize viewController = _viewController;

@synthesize notifyToken;
@synthesize userName;
@synthesize userPassword;
@synthesize userANI;        
@synthesize gmsURL;
@synthesize gmsVersion;

@synthesize language;

@synthesize locationManager;
@synthesize navController;

NSString *kUserNameKey			= @"userName";
NSString *kUserPasswordKey		= @"userPassword";
NSString *kUserANIKey           = @"userANI";
NSString *kGmsURLKey			= @"gmsURL";
NSString *kGmsVersionKey		= @"gmsVersion";

- (void)dealloc
{
    [_window release];
    [_viewController release];
    [super dealloc];
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    NSLog(@"Registering for push notifications...");    
    [[UIApplication sharedApplication] 
     registerForRemoteNotificationTypes:
     (UIRemoteNotificationTypeAlert | 
      UIRemoteNotificationTypeBadge | 
      UIRemoteNotificationTypeSound)];
    
    // Start the location manager.
    locationManager = [[CLLocationManager alloc] init];
    [locationManager setDesiredAccuracy:kCLLocationAccuracyNearestTenMeters];
    [locationManager setDelegate:self];
    [locationManager startUpdatingLocation];
    
    // Set the application defaults
    // listen for changes to our preferences when the Settings app does so,
    // when we are resumed from the backround, this will give us a chance to update our UI
    //
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(defaultsChanged:)
                                                 name:NSUserDefaultsDidChangeNotification
                                               object:nil];    
    //Initialize application preferences
    [self initPreferences];
    language = [[NSLocale preferredLanguages] objectAtIndex:0];    
    
    self.window = [[[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]] autorelease];
    // Override point for customization after application launch.
    self.viewController = [[[ViewController alloc] initWithNibName:@"ViewController" bundle:nil] autorelease];
    
    [self.viewController setTitle:@"GMS Sample"];
    self.navController = [[[UINavigationController alloc] initWithRootViewController:self.viewController] autorelease];
    self.navController.navigationBar.translucent = YES;
    self.navController.navigationBar.tintColor = [UIColor blackColor];
    self.navController.navigationBar.alpha = 0x7f;
    self.window.rootViewController = self.navController;
    [self.window makeKeyAndVisible];
    
    //The application was launched by a push notification message
    if (launchOptions != nil) {
        [[UIApplication sharedApplication] setApplicationIconBadgeNumber:0];
        
        for (id key in launchOptions) {
            NSLog(@"key: %@, value: %@", key, [launchOptions objectForKey:key]);
        }
        
        [[NSNotificationCenter defaultCenter] postNotificationName:NSGMSServerNotification object:self userInfo:launchOptions];
    }

    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    /*
     Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
     Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
     */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    /*
     Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
     If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
     */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    /*
     Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
     */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    /*
     Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
     */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    /*
     Called when the application is about to terminate.
     Save data if appropriate.
     See also applicationDidEnterBackground:.
     */
}

- (void)application:(UIApplication *)app didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken { 
    
    NSString *str  = [NSString 
                      stringWithFormat:@"%@", deviceToken];
    
    self.notifyToken = [str stringByReplacingOccurrencesOfString:@" " withString:@""];
    self.notifyToken = [notifyToken stringByReplacingOccurrencesOfString:@"<" withString:@""];
    self.notifyToken = [notifyToken stringByReplacingOccurrencesOfString:@">" withString:@""];
    
    NSLog(@"%@", self.notifyToken);    
}

- (void)application:(UIApplication *)app didFailToRegisterForRemoteNotificationsWithError:(NSError *)err { 
    notifyToken = @"Error";
    NSLog(@"%@", [NSString stringWithFormat: @"Error: %@", err]);    
    
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo {
    
    // get state
    UIApplicationState state = [application applicationState];
    if (state == UIApplicationStateActive) {
        //the app is in the foreground, so here you do your stuff since the OS does not do it for you
        //navigate the "aps" dictionary looking for "loc-args" and "loc-key", for example, or your personal payload)
    }
    else {
        //Application was brought from background to foreground
    }
    
    [[UIApplication sharedApplication] setApplicationIconBadgeNumber:0];
    
    for (id key in userInfo) {
        NSLog(@"key: %@, value: %@", key, [userInfo objectForKey:key]);
    }
    
    [[NSNotificationCenter defaultCenter] postNotificationName:NSGMSServerNotification object:self userInfo:userInfo];
}

- (NSString *) getDeviceToken {
    return self.notifyToken;
}

// we are being notified that our preferences have changed (user changed them in the Settings app)
// so read in the changes and update our UI.
//
- (void)defaultsChanged:(NSNotification *)notif
{
    [self initPreferences];
}

- (void)initPreferences
{
	userName = [[NSUserDefaults standardUserDefaults] stringForKey:kUserNameKey];
	userPassword = [[NSUserDefaults standardUserDefaults] stringForKey:kUserPasswordKey];
	userANI = [[NSUserDefaults standardUserDefaults] stringForKey:kUserANIKey];
	gmsURL = [[NSUserDefaults standardUserDefaults] stringForKey:kGmsURLKey];
	gmsVersion = [[NSUserDefaults standardUserDefaults] stringForKey:kGmsVersionKey];
    
	if ((userName == nil) || (userPassword == nil) || (userANI == nil) || (gmsURL == nil) || (gmsVersion == nil))
	{
		// no default values have been set, create them here based on what's in our Settings bundle info
		NSString *pathStr = [[NSBundle mainBundle] bundlePath];
		NSString *settingsBundlePath = [pathStr stringByAppendingPathComponent:@"Settings.bundle"];
		NSString *finalPath = [settingsBundlePath stringByAppendingPathComponent:@"Root.plist"];
        
		NSDictionary *settingsDict = [NSDictionary dictionaryWithContentsOfFile:finalPath];
		NSArray *prefSpecifierArray = [settingsDict objectForKey:@"PreferenceSpecifiers"];
        
		NSString *userNameDefault = nil;
		NSString *userPasswordDefault = nil;
		NSString *userANIDefault = nil;        
		NSString *gmsURLDefault = nil;
		NSString *gmsVersionDefault = nil;
		
		NSDictionary *prefItem;
		for (prefItem in prefSpecifierArray)
		{
			NSString *keyValueStr = [prefItem objectForKey:@"Key"];
			id defaultValue = [prefItem objectForKey:@"DefaultValue"];
			
			if ([keyValueStr isEqualToString:kUserNameKey])
			{
				userNameDefault = defaultValue;
			}
			else if ([keyValueStr isEqualToString:kUserPasswordKey])
			{
				userPasswordDefault = defaultValue;
			}
			else if ([keyValueStr isEqualToString:kUserANIKey])
			{
				userANIDefault = defaultValue;
			}            
			else if ([keyValueStr isEqualToString:kGmsURLKey])
			{
				gmsURLDefault = defaultValue;
			}
            else if ([keyValueStr isEqualToString:kGmsVersionKey])
			{
				gmsVersionDefault = defaultValue;
			}
		}
        
		// since no default values have been set (i.e. no preferences file created), create it here		
		NSDictionary *appDefaults = [NSDictionary dictionaryWithObjectsAndKeys:
                                     userNameDefault, kUserNameKey,
                                     userPasswordDefault, kUserPasswordKey,
                                     userANIDefault, kUserANIKey,
                                     gmsURLDefault, kGmsURLKey,
                                     gmsVersionDefault, kGmsVersionKey,
                                     nil];
        
		[[NSUserDefaults standardUserDefaults] registerDefaults:appDefaults];
		[[NSUserDefaults standardUserDefaults] synchronize];
	}
	
    // we're ready to go, so lastly set the key preference values
	userName = [[NSUserDefaults standardUserDefaults] stringForKey:kUserNameKey];
	userPassword = [[NSUserDefaults standardUserDefaults] stringForKey:kUserPasswordKey];
	userANI = [[NSUserDefaults standardUserDefaults] stringForKey:kUserANIKey];
	gmsURL = [[NSUserDefaults standardUserDefaults] stringForKey:kGmsURLKey];
	gmsVersion = [[NSUserDefaults standardUserDefaults] stringForKey:kGmsVersionKey];
}

@end
